/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

#include <cstdint>
#include <stdexcept>
#if defined(_WIN32)
	#include <WinSock2.h>
	#include <Windows.h>
	#include <io.h>
	#include <iphlpapi.h>
	#include <ws2ipdef.h>
	#include <ws2tcpip.h>

// Must be last.
	#include <icmpapi.h>
	#define BOTH_DIRECTION SD_BOTH
static inline void WSAStartup()
{
	static bool inited = []() {
		WSADATA wsaData;
		if (WSAStartup(MAKEWORD(2, 2), &wsaData) != 0)
			throw std::runtime_error("Could not initialize network.");
		return true;
	}();
}
#else
	#include <arpa/inet.h>
	#include <net/if.h>
	#include <netinet/ip_icmp.h>
	#include <ifaddrs.h>
	#include <linux/if_link.h>
	#include <netdb.h>
	#include <netinet/in.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <unistd.h>
	#define SOCKET int
	#define INVALID_SOCKET (-1)
	#define SOCKET_ERROR (-1)
	#define BOTH_DIRECTION SHUT_RDWR
	#ifndef __INTIME__
		#define closesocket(s) close((s))
	#endif
#endif
